use ottawaparking;


CREATE TABLE tickets_2010 (
    id_Column MEDIUMINT NOT NULL AUTO_INCREMENT PRIMARY KEY,
    Issue_No VARCHAR(8),
    Issue_Date DATE,
    Issue_Time TIME,
    Agency VARCHAR(29),
    Officer_Badge VARCHAR(5),
    Beat VARCHAR(4),
    VIOCode VARCHAR(20),
    VIODescription VARCHAR(70),
    VIOType VARCHAR(40),
    VIOFine VARCHAR(5),
    VIOlateFee VARCHAR(3),
    Street VARCHAR(45),
    a_between VARCHAR(25),
    a_and VARCHAR(25),
    side_of_street VARCHAR(10),
    meter_number VARCHAR(10),
    total_voided VARCHAR(10),
    total_non_cash_credit VARCHAR(10),
    total_fines_and_fees VARCHAR(10),
    total_credits VARCHAR(10),
    total_fines VARCHAR(10),
    amount_due VARCHAR(10),
    due_date DATE,
    REC_Status VARCHAR(2),
    REC_Status_Date DATE,
    REC_Cleared_Reason VARCHAR(50),
    Void_Status VARCHAR(50),
    Review_Code VARCHAR(50),
    Trial_Code VARCHAR(100)
);

select *
from tickets_2010;



 UPDATE tickets_2010
SET REC_Cleared_Reason = CASE 
	WHEN  REC_Cleared_Reason = 'DP'  THEN 'Payment at the MTO or at a Collections Agency'
	WHEN  REC_Cleared_Reason = 'PD' THEN 'Paid'
    WHEN  REC_Cleared_Reason = 'SP' THEN 'Suspended'
    WHEN  REC_Cleared_Reason = 'VO' THEN 'Void'
    WHEN  REC_Cleared_Reason = 'XX' THEN 'Open'
	ELSE NULL
END;
   
   UPDATE tickets_2010
SET Review_Code = CASE 
	WHEN  Review_Code = 'ROD'  THEN 'Review outcome denied'
	WHEN  Review_Code = 'ROU' THEN 'Review outcome upheld'
    WHEN  Review_Code = 'RR' THEN 'Review requested'
    WHEN  Review_Code = 'RRA' THEN 'Review request accepted'
    WHEN  Review_Code = 'RRD' THEN 'Review request denied'
    When Review_Code = '' THEN 'No review'
	ELSE NULL
END;


   UPDATE tickets_2010
SET Trial_Code = CASE 
	WHEN  Trial_Code LIKE '%AOD%'  THEN 'Appeal outcome denied'
	WHEN  Trial_Code LIKE '%AON%'  THEN 'Appeal outcome withdrawn'
    WHEN  Trial_Code LIKE '%AOS%'  THEN 'Appeal outcome suspended'
    WHEN  Trial_Code LIKE '%CFR%'  THEN 'Conviction of failure to respond'
    WHEN  Trial_Code LIKE '%CRC%'  THEN 'Certificate requesting conviction'
    When  Trial_Code LIKE '%CRPD%' THEN 'Certificate requesting plate denial'
	WHEN  Trial_Code LIKE '%JRA%'  THEN 'Adjournment request accepted'
    WHEN  Trial_Code LIKE '%NFDD%' THEN 'Notice of fine and due date'
    When  Trial_Code LIKE '%NIC%'  THEN 'Notice of impending conviction'
    WHEN  Trial_Code LIKE '%NOT%'  THEN 'Notice of trial'
	WHEN  Trial_Code LIKE '%ORG%'  THEN 'Reopen outcome guilty / impose set fine'
    WHEN  Trial_Code LIKE '%ORT%'  THEN 'Reopen outcome conviction struck / new trial'
    WHEN  Trial_Code LIKE '%SOC%'  THEN 'Strike out conviction'
    WHEN  Trial_Code LIKE '%SOCR%' THEN 'Request to strike out conviction'
    When  Trial_Code LIKE '%TOA%'  THEN 'Trial outcome adjourned'
	WHEN  Trial_Code LIKE '%TOD%'  THEN 'Trial outcome denied'
    WHEN  Trial_Code LIKE '%TOU%'  THEN 'Trial outcome convicted'
    When  Trial_Code LIKE '%TR%'   THEN 'Trial request'
    WHEN  Trial_Code LIKE '%TRA%'  THEN 'Trial request accepted'
    WHEN  Trial_Code LIKE '%TS%'   THEN 'Trial scheduled'
    When  Trial_Code LIKE '%%'     THEN 'Dealt with prior to notices being sent'
	ELSE NULL
END;

select *
from tickets_2010;


CREATE TABLE tickets_2011 (
    id_Column MEDIUMINT NOT NULL AUTO_INCREMENT PRIMARY KEY,
    Issue_No VARCHAR(8),
    Issue_Date DATE,
    Issue_Time TIME,
    Agency VARCHAR(29),
    Officer_Badge VARCHAR(5),
    Beat VARCHAR(4),
    VIOCode VARCHAR(20),
    VIODescription VARCHAR(70),
    VIOType VARCHAR(40),
    VIOFine VARCHAR(5),
    VIOlateFee VARCHAR(3),
    Street VARCHAR(45),
    a_between VARCHAR(25),
    a_and VARCHAR(25),
    side_of_street VARCHAR(10),
    meter_number VARCHAR(10),
    total_voided VARCHAR(10),
    total_non_cash_credit VARCHAR(10),
    total_fines_and_fees VARCHAR(10),
    total_credits VARCHAR(10),
    total_fines VARCHAR(10),
    amount_due VARCHAR(10),
    due_date DATE,
    REC_Status VARCHAR(2),
    REC_Status_Date DATE,
    REC_Cleared_Reason VARCHAR(2),
    Void_Status VARCHAR(2),
    Review_Code VARCHAR(3),
    Trial_Code VARCHAR(5)
);

ALTER TABLE tickets_2011 MODIFY REC_Cleared_Reason VARCHAR(50);
ALTER TABLE tickets_2011 MODIFY Void_Status VARCHAR(50);
ALTER TABLE tickets_2011 MODIFY Review_Code VARCHAR(50);
ALTER TABLE tickets_2011 MODIFY Trial_Code VARCHAR(100);

 UPDATE tickets_2011
SET REC_Cleared_Reason = CASE 
	WHEN  REC_Cleared_Reason = 'DP'  THEN 'Payment at the MTO or at a Collections Agency'
	WHEN  REC_Cleared_Reason = 'PD' THEN 'Paid'
    WHEN  REC_Cleared_Reason = 'SP' THEN 'Suspended'
    WHEN  REC_Cleared_Reason = 'VO' THEN 'Void'
    WHEN  REC_Cleared_Reason = 'XX' THEN 'Open'
	ELSE NULL
END;
   
   UPDATE tickets_2011
SET Review_Code = CASE 
	WHEN  Review_Code = 'ROD'  THEN 'Review outcome denied'
	WHEN  Review_Code = 'ROU' THEN 'Review outcome upheld'
    WHEN  Review_Code = 'RR' THEN 'Review requested'
    WHEN  Review_Code = 'RRA' THEN 'Review request accepted'
    WHEN  Review_Code = 'RRD' THEN 'Review request denied'
    When Review_Code = '' THEN 'No review'
	ELSE NULL
END;


   UPDATE tickets_2011
SET Trial_Code = CASE 
	WHEN  Trial_Code LIKE '%AOD%'  THEN 'Appeal outcome denied'
	WHEN  Trial_Code LIKE '%AON%'  THEN 'Appeal outcome withdrawn'
    WHEN  Trial_Code LIKE '%AOS%'  THEN 'Appeal outcome suspended'
    WHEN  Trial_Code LIKE '%CFR%'  THEN 'Conviction of failure to respond'
    WHEN  Trial_Code LIKE '%CRC%'  THEN 'Certificate requesting conviction'
    When  Trial_Code LIKE '%CRPD%' THEN 'Certificate requesting plate denial'
	WHEN  Trial_Code LIKE '%JRA%'  THEN 'Adjournment request accepted'
    WHEN  Trial_Code LIKE '%NFDD%' THEN 'Notice of fine and due date'
    When  Trial_Code LIKE '%NIC%'  THEN 'Notice of impending conviction'
    WHEN  Trial_Code LIKE '%NOT%'  THEN 'Notice of trial'
	WHEN  Trial_Code LIKE '%ORG%'  THEN 'Reopen outcome guilty / impose set fine'
    WHEN  Trial_Code LIKE '%ORT%'  THEN 'Reopen outcome conviction struck / new trial'
    WHEN  Trial_Code LIKE '%SOC%'  THEN 'Strike out conviction'
    WHEN  Trial_Code LIKE '%SOCR%' THEN 'Request to strike out conviction'
    When  Trial_Code LIKE '%TOA%'  THEN 'Trial outcome adjourned'
	WHEN  Trial_Code LIKE '%TOD%'  THEN 'Trial outcome denied'
    WHEN  Trial_Code LIKE '%TOU%'  THEN 'Trial outcome convicted'
    When  Trial_Code LIKE '%TR%'   THEN 'Trial request'
    WHEN  Trial_Code LIKE '%TRA%'  THEN 'Trial request accepted'
    WHEN  Trial_Code LIKE '%TS%'   THEN 'Trial scheduled'
    When  Trial_Code LIKE '%%'     THEN 'Dealt with prior to notices being sent'
	ELSE NULL
END;

select *
from tickets_2011;



CREATE TABLE tickets_2012 (
    id_Column MEDIUMINT NOT NULL AUTO_INCREMENT PRIMARY KEY,
    Issue_No VARCHAR(8),
    Issue_Date DATE,
    Issue_Time TIME,
    Agency VARCHAR(29),
    Officer_Badge VARCHAR(5),
    Beat VARCHAR(4),
    VIOCode VARCHAR(17),
    VIODescription VARCHAR(70),
    VIOType VARCHAR(40),
    VIOFine VARCHAR(5),
    VIOlateFee VARCHAR(3),
    Street VARCHAR(45),
    a_between VARCHAR(20),
    a_and VARCHAR(20),
    side_of_street VARCHAR(5),
    meter_number VARCHAR(5),
    total_voided VARCHAR(4),
    total_non_cash_credit VARCHAR(4),
    total_fines_and_fees VARCHAR(6),
    total_credits VARCHAR(6),
    total_fines VARCHAR(5),
    amount_due VARCHAR(6),
    due_date DATE,
    REC_Status VARCHAR(2),
    REC_Status_Date DATE,
    REC_Cleared_Reason VARCHAR(2),
    Void_Status VARCHAR(2),
    Review_Code VARCHAR(3),
    Trial_Code VARCHAR(5)
);

ALTER TABLE tickets_2012 MODIFY REC_Cleared_Reason VARCHAR(50);
ALTER TABLE tickets_2012 MODIFY Void_Status VARCHAR(50);
ALTER TABLE tickets_2012 MODIFY Review_Code VARCHAR(50);
ALTER TABLE tickets_2012 MODIFY Trial_Code VARCHAR(100);

 UPDATE tickets_2012
SET REC_Cleared_Reason = CASE 
	WHEN  REC_Cleared_Reason = 'DP'  THEN 'Payment at the MTO or at a Collections Agency'
	WHEN  REC_Cleared_Reason = 'PD' THEN 'Paid'
    WHEN  REC_Cleared_Reason = 'SP' THEN 'Suspended'
    WHEN  REC_Cleared_Reason = 'VO' THEN 'Void'
    WHEN  REC_Cleared_Reason = 'XX' THEN 'Open'
	ELSE NULL
END;
   
   UPDATE tickets_2012
SET Review_Code = CASE 
	WHEN  Review_Code = 'ROD'  THEN 'Review outcome denied'
	WHEN  Review_Code = 'ROU' THEN 'Review outcome upheld'
    WHEN  Review_Code = 'RR' THEN 'Review requested'
    WHEN  Review_Code = 'RRA' THEN 'Review request accepted'
    WHEN  Review_Code = 'RRD' THEN 'Review request denied'
    When Review_Code = '' THEN 'No review'
	ELSE NULL
END;


   UPDATE tickets_2012
SET Trial_Code = CASE 
	WHEN  Trial_Code LIKE '%AOD%'  THEN 'Appeal outcome denied'
	WHEN  Trial_Code LIKE '%AON%'  THEN 'Appeal outcome withdrawn'
    WHEN  Trial_Code LIKE '%AOS%'  THEN 'Appeal outcome suspended'
    WHEN  Trial_Code LIKE '%CFR%'  THEN 'Conviction of failure to respond'
    WHEN  Trial_Code LIKE '%CRC%'  THEN 'Certificate requesting conviction'
    When  Trial_Code LIKE '%CRPD%' THEN 'Certificate requesting plate denial'
	WHEN  Trial_Code LIKE '%JRA%'  THEN 'Adjournment request accepted'
    WHEN  Trial_Code LIKE '%NFDD%' THEN 'Notice of fine and due date'
    When  Trial_Code LIKE '%NIC%'  THEN 'Notice of impending conviction'
    WHEN  Trial_Code LIKE '%NOT%'  THEN 'Notice of trial'
	WHEN  Trial_Code LIKE '%ORG%'  THEN 'Reopen outcome guilty / impose set fine'
    WHEN  Trial_Code LIKE '%ORT%'  THEN 'Reopen outcome conviction struck / new trial'
    WHEN  Trial_Code LIKE '%SOC%'  THEN 'Strike out conviction'
    WHEN  Trial_Code LIKE '%SOCR%' THEN 'Request to strike out conviction'
    When  Trial_Code LIKE '%TOA%'  THEN 'Trial outcome adjourned'
	WHEN  Trial_Code LIKE '%TOD%'  THEN 'Trial outcome denied'
    WHEN  Trial_Code LIKE '%TOU%'  THEN 'Trial outcome convicted'
    When  Trial_Code LIKE '%TR%'   THEN 'Trial request'
    WHEN  Trial_Code LIKE '%TRA%'  THEN 'Trial request accepted'
    WHEN  Trial_Code LIKE '%TS%'   THEN 'Trial scheduled'
    When  Trial_Code LIKE '%%'     THEN 'Dealt with prior to notices being sent'
	ELSE NULL
END;

select *
from tickets_2012;

CREATE TABLE tickets_2013 (
    id_Column MEDIUMINT NOT NULL AUTO_INCREMENT PRIMARY KEY,
    Issue_No VARCHAR(8),
    Issue_Date DATE,
    Issue_Time TIME,
    Agency VARCHAR(29),
    Officer_Badge VARCHAR(5),
    Beat VARCHAR(4),
    VIOCode VARCHAR(20),
    VIODescription VARCHAR(70),
    VIOType VARCHAR(40),
    VIOFine VARCHAR(5),
    VIOlateFee VARCHAR(3),
    Street VARCHAR(45),
    a_between VARCHAR(25),
    a_and VARCHAR(25),
    side_of_street VARCHAR(10),
    meter_number VARCHAR(10),
    total_voided VARCHAR(10),
    total_non_cash_credit VARCHAR(10),
    total_fines_and_fees VARCHAR(10),
    total_credits VARCHAR(10),
    total_fines VARCHAR(10),
    amount_due VARCHAR(10),
    due_date DATE,
    REC_Status VARCHAR(2),
    REC_Status_Date DATE,
    REC_Cleared_Reason VARCHAR(2),
    Void_Status VARCHAR(2),
    Review_Code VARCHAR(3),
    Trial_Code VARCHAR(5)
);

ALTER TABLE tickets_2013 MODIFY REC_Cleared_Reason VARCHAR(50);
ALTER TABLE tickets_2013 MODIFY Void_Status VARCHAR(50);
ALTER TABLE tickets_2013 MODIFY Review_Code VARCHAR(50);
ALTER TABLE tickets_2013 MODIFY Trial_Code VARCHAR(100);

 UPDATE tickets_2013
SET REC_Cleared_Reason = CASE 
	WHEN  REC_Cleared_Reason = 'DP'  THEN 'Payment at the MTO or at a Collections Agency'
	WHEN  REC_Cleared_Reason = 'PD' THEN 'Paid'
    WHEN  REC_Cleared_Reason = 'SP' THEN 'Suspended'
    WHEN  REC_Cleared_Reason = 'VO' THEN 'Void'
    WHEN  REC_Cleared_Reason = 'XX' THEN 'Open'
	ELSE NULL
END;
   
   UPDATE tickets_2013
SET Review_Code = CASE 
	WHEN  Review_Code = 'ROD'  THEN 'Review outcome denied'
	WHEN  Review_Code = 'ROU' THEN 'Review outcome upheld'
    WHEN  Review_Code = 'RR' THEN 'Review requested'
    WHEN  Review_Code = 'RRA' THEN 'Review request accepted'
    WHEN  Review_Code = 'RRD' THEN 'Review request denied'
    When Review_Code = '' THEN 'No review'
	ELSE NULL
END;


   UPDATE tickets_2013
SET Trial_Code = CASE 
	WHEN  Trial_Code LIKE '%AOD%'  THEN 'Appeal outcome denied'
	WHEN  Trial_Code LIKE '%AON%'  THEN 'Appeal outcome withdrawn'
    WHEN  Trial_Code LIKE '%AOS%'  THEN 'Appeal outcome suspended'
    WHEN  Trial_Code LIKE '%CFR%'  THEN 'Conviction of failure to respond'
    WHEN  Trial_Code LIKE '%CRC%'  THEN 'Certificate requesting conviction'
    When  Trial_Code LIKE '%CRPD%' THEN 'Certificate requesting plate denial'
	WHEN  Trial_Code LIKE '%JRA%'  THEN 'Adjournment request accepted'
    WHEN  Trial_Code LIKE '%NFDD%' THEN 'Notice of fine and due date'
    When  Trial_Code LIKE '%NIC%'  THEN 'Notice of impending conviction'
    WHEN  Trial_Code LIKE '%NOT%'  THEN 'Notice of trial'
	WHEN  Trial_Code LIKE '%ORG%'  THEN 'Reopen outcome guilty / impose set fine'
    WHEN  Trial_Code LIKE '%ORT%'  THEN 'Reopen outcome conviction struck / new trial'
    WHEN  Trial_Code LIKE '%SOC%'  THEN 'Strike out conviction'
    WHEN  Trial_Code LIKE '%SOCR%' THEN 'Request to strike out conviction'
    When  Trial_Code LIKE '%TOA%'  THEN 'Trial outcome adjourned'
	WHEN  Trial_Code LIKE '%TOD%'  THEN 'Trial outcome denied'
    WHEN  Trial_Code LIKE '%TOU%'  THEN 'Trial outcome convicted'
    When  Trial_Code LIKE '%TR%'   THEN 'Trial request'
    WHEN  Trial_Code LIKE '%TRA%'  THEN 'Trial request accepted'
    WHEN  Trial_Code LIKE '%TS%'   THEN 'Trial scheduled'
    When  Trial_Code LIKE '%%'     THEN 'Dealt with prior to notices being sent'
	ELSE NULL
END;

select *
from tickets_2013;

CREATE TABLE tickets_2014 (
    id_Column MEDIUMINT NOT NULL AUTO_INCREMENT PRIMARY KEY,
    Issue_No VARCHAR(8),
    Issue_Date DATE,
    Issue_Time TIME,
    Agency VARCHAR(29),
    Officer_Badge VARCHAR(5),
    Beat VARCHAR(4),
    VIOCode VARCHAR(20),
    VIODescription VARCHAR(70),
    VIOType VARCHAR(40),
    VIOFine VARCHAR(5),
    VIOlateFee VARCHAR(3),
    Street VARCHAR(45),
    a_between VARCHAR(25),
    a_and VARCHAR(25),
    side_of_street VARCHAR(10),
    meter_number VARCHAR(10),
    total_voided VARCHAR(10),
    total_non_cash_credit VARCHAR(10),
    total_fines_and_fees VARCHAR(10),
    total_credits VARCHAR(10),
    total_fines VARCHAR(10),
    amount_due VARCHAR(10),
    due_date DATE,
    REC_Status VARCHAR(2),
    REC_Status_Date DATE,
    REC_Cleared_Reason VARCHAR(2),
    Void_Status VARCHAR(2),
    Review_Code VARCHAR(3),
    Trial_Code VARCHAR(5)
);

ALTER TABLE tickets_2014 MODIFY REC_Cleared_Reason VARCHAR(50);
ALTER TABLE tickets_2014 MODIFY Void_Status VARCHAR(50);
ALTER TABLE tickets_2014 MODIFY Review_Code VARCHAR(50);
ALTER TABLE tickets_2014 MODIFY Trial_Code VARCHAR(100);

 UPDATE tickets_2014
SET REC_Cleared_Reason = CASE 
	WHEN  REC_Cleared_Reason = 'DP'  THEN 'Payment at the MTO or at a Collections Agency'
	WHEN  REC_Cleared_Reason = 'PD' THEN 'Paid'
    WHEN  REC_Cleared_Reason = 'SP' THEN 'Suspended'
    WHEN  REC_Cleared_Reason = 'VO' THEN 'Void'
    WHEN  REC_Cleared_Reason = 'XX' THEN 'Open'
	ELSE NULL
END;
   
   UPDATE tickets_2014
SET Review_Code = CASE 
	WHEN  Review_Code = 'ROD'  THEN 'Review outcome denied'
	WHEN  Review_Code = 'ROU' THEN 'Review outcome upheld'
    WHEN  Review_Code = 'RR' THEN 'Review requested'
    WHEN  Review_Code = 'RRA' THEN 'Review request accepted'
    WHEN  Review_Code = 'RRD' THEN 'Review request denied'
    When Review_Code = '' THEN 'No review'
	ELSE NULL
END;


   UPDATE tickets_2014
SET Trial_Code = CASE 
	WHEN  Trial_Code LIKE '%AOD%'  THEN 'Appeal outcome denied'
	WHEN  Trial_Code LIKE '%AON%'  THEN 'Appeal outcome withdrawn'
    WHEN  Trial_Code LIKE '%AOS%'  THEN 'Appeal outcome suspended'
    WHEN  Trial_Code LIKE '%CFR%'  THEN 'Conviction of failure to respond'
    WHEN  Trial_Code LIKE '%CRC%'  THEN 'Certificate requesting conviction'
    When  Trial_Code LIKE '%CRPD%' THEN 'Certificate requesting plate denial'
	WHEN  Trial_Code LIKE '%JRA%'  THEN 'Adjournment request accepted'
    WHEN  Trial_Code LIKE '%NFDD%' THEN 'Notice of fine and due date'
    When  Trial_Code LIKE '%NIC%'  THEN 'Notice of impending conviction'
    WHEN  Trial_Code LIKE '%NOT%'  THEN 'Notice of trial'
	WHEN  Trial_Code LIKE '%ORG%'  THEN 'Reopen outcome guilty / impose set fine'
    WHEN  Trial_Code LIKE '%ORT%'  THEN 'Reopen outcome conviction struck / new trial'
    WHEN  Trial_Code LIKE '%SOC%'  THEN 'Strike out conviction'
    WHEN  Trial_Code LIKE '%SOCR%' THEN 'Request to strike out conviction'
    When  Trial_Code LIKE '%TOA%'  THEN 'Trial outcome adjourned'
	WHEN  Trial_Code LIKE '%TOD%'  THEN 'Trial outcome denied'
    WHEN  Trial_Code LIKE '%TOU%'  THEN 'Trial outcome convicted'
    When  Trial_Code LIKE '%TR%'   THEN 'Trial request'
    WHEN  Trial_Code LIKE '%TRA%'  THEN 'Trial request accepted'
    WHEN  Trial_Code LIKE '%TS%'   THEN 'Trial scheduled'
    When  Trial_Code LIKE '%%'     THEN 'Dealt with prior to notices being sent'
	ELSE NULL
END;

select *
from tickets_2014;

CREATE TABLE tickets_2015 (
    id_Column MEDIUMINT NOT NULL AUTO_INCREMENT PRIMARY KEY,
    Issue_No VARCHAR(8),
    Issue_Date DATE,
    Issue_Time TIME,
    Agency VARCHAR(29),
    Officer_Badge VARCHAR(5),
    Beat VARCHAR(4),
    VIOCode VARCHAR(20),
    VIODescription VARCHAR(70),
    VIOType VARCHAR(40),
    VIOFine VARCHAR(5),
    VIOlateFee VARCHAR(3),
    Street VARCHAR(45),
    a_between VARCHAR(25),
    a_and VARCHAR(25),
    side_of_street VARCHAR(10),
    meter_number VARCHAR(10),
    total_voided VARCHAR(10),
    total_non_cash_credit VARCHAR(10),
    total_fines_and_fees VARCHAR(10),
    total_credits VARCHAR(10),
    total_fines VARCHAR(10),
    amount_due VARCHAR(10),
    due_date DATE,
    REC_Status VARCHAR(2),
    REC_Status_Date DATE,
    REC_Cleared_Reason VARCHAR(2),
    Void_Status VARCHAR(2),
    Review_Code VARCHAR(3),
    Trial_Code VARCHAR(5)
);

ALTER TABLE tickets_2015 MODIFY REC_Cleared_Reason VARCHAR(50);
ALTER TABLE tickets_2015 MODIFY Void_Status VARCHAR(50);
ALTER TABLE tickets_2015 MODIFY Review_Code VARCHAR(50);
ALTER TABLE tickets_2015 MODIFY Trial_Code VARCHAR(100);

 UPDATE tickets_2015
SET REC_Cleared_Reason = CASE 
	WHEN  REC_Cleared_Reason = 'DP'  THEN 'Payment at the MTO or at a Collections Agency'
	WHEN  REC_Cleared_Reason = 'PD' THEN 'Paid'
    WHEN  REC_Cleared_Reason = 'SP' THEN 'Suspended'
    WHEN  REC_Cleared_Reason = 'VO' THEN 'Void'
    WHEN  REC_Cleared_Reason = 'XX' THEN 'Open'
	ELSE NULL
END;
   
   UPDATE tickets_2015
SET Review_Code = CASE 
	WHEN  Review_Code = 'ROD'  THEN 'Review outcome denied'
	WHEN  Review_Code = 'ROU' THEN 'Review outcome upheld'
    WHEN  Review_Code = 'RR' THEN 'Review requested'
    WHEN  Review_Code = 'RRA' THEN 'Review request accepted'
    WHEN  Review_Code = 'RRD' THEN 'Review request denied'
    When Review_Code = '' THEN 'No review'
	ELSE NULL
END;


   UPDATE tickets_2015
SET Trial_Code = CASE 
	WHEN  Trial_Code LIKE '%AOD%'  THEN 'Appeal outcome denied'
	WHEN  Trial_Code LIKE '%AON%'  THEN 'Appeal outcome withdrawn'
    WHEN  Trial_Code LIKE '%AOS%'  THEN 'Appeal outcome suspended'
    WHEN  Trial_Code LIKE '%CFR%'  THEN 'Conviction of failure to respond'
    WHEN  Trial_Code LIKE '%CRC%'  THEN 'Certificate requesting conviction'
    When  Trial_Code LIKE '%CRPD%' THEN 'Certificate requesting plate denial'
	WHEN  Trial_Code LIKE '%JRA%'  THEN 'Adjournment request accepted'
    WHEN  Trial_Code LIKE '%NFDD%' THEN 'Notice of fine and due date'
    When  Trial_Code LIKE '%NIC%'  THEN 'Notice of impending conviction'
    WHEN  Trial_Code LIKE '%NOT%'  THEN 'Notice of trial'
	WHEN  Trial_Code LIKE '%ORG%'  THEN 'Reopen outcome guilty / impose set fine'
    WHEN  Trial_Code LIKE '%ORT%'  THEN 'Reopen outcome conviction struck / new trial'
    WHEN  Trial_Code LIKE '%SOC%'  THEN 'Strike out conviction'
    WHEN  Trial_Code LIKE '%SOCR%' THEN 'Request to strike out conviction'
    When  Trial_Code LIKE '%TOA%'  THEN 'Trial outcome adjourned'
	WHEN  Trial_Code LIKE '%TOD%'  THEN 'Trial outcome denied'
    WHEN  Trial_Code LIKE '%TOU%'  THEN 'Trial outcome convicted'
    When  Trial_Code LIKE '%TR%'   THEN 'Trial request'
    WHEN  Trial_Code LIKE '%TRA%'  THEN 'Trial request accepted'
    WHEN  Trial_Code LIKE '%TS%'   THEN 'Trial scheduled'
    When  Trial_Code LIKE '%%'     THEN 'Dealt with prior to notices being sent'
	ELSE NULL
END;

select *
from tickets_2015;

CREATE TABLE tickets_2015_16 (
    id_Column MEDIUMINT NOT NULL AUTO_INCREMENT PRIMARY KEY,
    Issue_No VARCHAR(8),
    Issue_Date DATE,
    Issue_Time TIME,
    Agency VARCHAR(29),
    Officer_Badge VARCHAR(5),
    Beat VARCHAR(4),
    VIOCode VARCHAR(20),
    VIODescription VARCHAR(70),
    VIOType VARCHAR(40),
    VIOFine VARCHAR(5),
    VIOlateFee VARCHAR(3),
    Street VARCHAR(45),
    a_between VARCHAR(25),
    a_and VARCHAR(25),
    side_of_street VARCHAR(10),
    meter_number VARCHAR(10),
    total_voided VARCHAR(10),
    total_non_cash_credit VARCHAR(10),
    total_fines_and_fees VARCHAR(10),
    total_credits VARCHAR(10),
    total_fines VARCHAR(10),
    amount_due VARCHAR(10),
    due_date DATE,
    REC_Status VARCHAR(2),
    REC_Status_Date DATE,
    REC_Cleared_Reason VARCHAR(2),
    Void_Status VARCHAR(2),
    Review_Code VARCHAR(3),
    Trial_Code VARCHAR(5)
);

ALTER TABLE tickets_2015_16 MODIFY REC_Cleared_Reason VARCHAR(50);
ALTER TABLE tickets_2015_16 MODIFY Void_Status VARCHAR(50);
ALTER TABLE tickets_2015_16 MODIFY Review_Code VARCHAR(50);
ALTER TABLE tickets_2015_16 MODIFY Trial_Code VARCHAR(100);

 UPDATE tickets_2015_16
SET REC_Cleared_Reason = CASE 
	WHEN  REC_Cleared_Reason = 'DP'  THEN 'Payment at the MTO or at a Collections Agency'
	WHEN  REC_Cleared_Reason = 'PD' THEN 'Paid'
    WHEN  REC_Cleared_Reason = 'SP' THEN 'Suspended'
    WHEN  REC_Cleared_Reason = 'VO' THEN 'Void'
    WHEN  REC_Cleared_Reason = 'XX' THEN 'Open'
	ELSE NULL
END;
   
   UPDATE tickets_2015_16
SET Review_Code = CASE 
	WHEN  Review_Code = 'ROD'  THEN 'Review outcome denied'
	WHEN  Review_Code = 'ROU' THEN 'Review outcome upheld'
    WHEN  Review_Code = 'RR' THEN 'Review requested'
    WHEN  Review_Code = 'RRA' THEN 'Review request accepted'
    WHEN  Review_Code = 'RRD' THEN 'Review request denied'
    When Review_Code = '' THEN 'No review'
	ELSE NULL
END;


   UPDATE tickets_2015_16
SET Trial_Code = CASE 
	WHEN  Trial_Code LIKE '%AOD%'  THEN 'Appeal outcome denied'
	WHEN  Trial_Code LIKE '%AON%'  THEN 'Appeal outcome withdrawn'
    WHEN  Trial_Code LIKE '%AOS%'  THEN 'Appeal outcome suspended'
    WHEN  Trial_Code LIKE '%CFR%'  THEN 'Conviction of failure to respond'
    WHEN  Trial_Code LIKE '%CRC%'  THEN 'Certificate requesting conviction'
    When  Trial_Code LIKE '%CRPD%' THEN 'Certificate requesting plate denial'
	WHEN  Trial_Code LIKE '%JRA%'  THEN 'Adjournment request accepted'
    WHEN  Trial_Code LIKE '%NFDD%' THEN 'Notice of fine and due date'
    When  Trial_Code LIKE '%NIC%'  THEN 'Notice of impending conviction'
    WHEN  Trial_Code LIKE '%NOT%'  THEN 'Notice of trial'
	WHEN  Trial_Code LIKE '%ORG%'  THEN 'Reopen outcome guilty / impose set fine'
    WHEN  Trial_Code LIKE '%ORT%'  THEN 'Reopen outcome conviction struck / new trial'
    WHEN  Trial_Code LIKE '%SOC%'  THEN 'Strike out conviction'
    WHEN  Trial_Code LIKE '%SOCR%' THEN 'Request to strike out conviction'
    When  Trial_Code LIKE '%TOA%'  THEN 'Trial outcome adjourned'
	WHEN  Trial_Code LIKE '%TOD%'  THEN 'Trial outcome denied'
    WHEN  Trial_Code LIKE '%TOU%'  THEN 'Trial outcome convicted'
    When  Trial_Code LIKE '%TR%'   THEN 'Trial request'
    WHEN  Trial_Code LIKE '%TRA%'  THEN 'Trial request accepted'
    WHEN  Trial_Code LIKE '%TS%'   THEN 'Trial scheduled'
    When  Trial_Code LIKE '%%'     THEN 'Dealt with prior to notices being sent'
	ELSE NULL
END;

select *
from tickets_2015_16;

CREATE TABLE tickets_2016_17 (
    id_Column MEDIUMINT NOT NULL AUTO_INCREMENT PRIMARY KEY,
    Issue_No VARCHAR(8),
    Issue_Date DATE,
    Issue_Time TIME,
    Agency VARCHAR(29),
    Officer_Badge VARCHAR(5),
    Beat VARCHAR(4),
    VIOCode VARCHAR(20),
    VIODescription VARCHAR(70),
    VIOType VARCHAR(40),
    VIOFine VARCHAR(5),
    VIOlateFee VARCHAR(3),
    Street VARCHAR(45),
    a_between VARCHAR(25),
    a_and VARCHAR(25),
    side_of_street VARCHAR(10),
    meter_number VARCHAR(10),
    total_voided VARCHAR(10),
    total_non_cash_credit VARCHAR(10),
    total_fines_and_fees VARCHAR(10),
    total_credits VARCHAR(10),
    total_fines VARCHAR(10),
    amount_due VARCHAR(10),
    due_date DATE,
    REC_Status VARCHAR(2),
    REC_Status_Date DATE,
    REC_Cleared_Reason VARCHAR(2),
    Void_Status VARCHAR(2),
    Review_Code VARCHAR(3),
    Trial_Code VARCHAR(5)
);

ALTER TABLE tickets_2016_17 MODIFY REC_Cleared_Reason VARCHAR(50);
ALTER TABLE tickets_2016_17 MODIFY Void_Status VARCHAR(50);
ALTER TABLE tickets_2016_17 MODIFY Review_Code VARCHAR(50);
ALTER TABLE tickets_2016_17 MODIFY Trial_Code VARCHAR(100);

 UPDATE tickets_2016_17
SET REC_Cleared_Reason = CASE 
	WHEN  REC_Cleared_Reason = 'DP'  THEN 'Payment at the MTO or at a Collections Agency'
	WHEN  REC_Cleared_Reason = 'PD' THEN 'Paid'
    WHEN  REC_Cleared_Reason = 'SP' THEN 'Suspended'
    WHEN  REC_Cleared_Reason = 'VO' THEN 'Void'
    WHEN  REC_Cleared_Reason = 'XX' THEN 'Open'
	ELSE NULL
END;
   
   UPDATE tickets_2016_17
SET Review_Code = CASE 
	WHEN  Review_Code = 'ROD'  THEN 'Review outcome denied'
	WHEN  Review_Code = 'ROU' THEN 'Review outcome upheld'
    WHEN  Review_Code = 'RR' THEN 'Review requested'
    WHEN  Review_Code = 'RRA' THEN 'Review request accepted'
    WHEN  Review_Code = 'RRD' THEN 'Review request denied'
    When Review_Code = '' THEN 'No review'
	ELSE NULL
END;


   UPDATE tickets_2016_17
SET Trial_Code = CASE 
	WHEN  Trial_Code LIKE '%AOD%'  THEN 'Appeal outcome denied'
	WHEN  Trial_Code LIKE '%AON%'  THEN 'Appeal outcome withdrawn'
    WHEN  Trial_Code LIKE '%AOS%'  THEN 'Appeal outcome suspended'
    WHEN  Trial_Code LIKE '%CFR%'  THEN 'Conviction of failure to respond'
    WHEN  Trial_Code LIKE '%CRC%'  THEN 'Certificate requesting conviction'
    When  Trial_Code LIKE '%CRPD%' THEN 'Certificate requesting plate denial'
	WHEN  Trial_Code LIKE '%JRA%'  THEN 'Adjournment request accepted'
    WHEN  Trial_Code LIKE '%NFDD%' THEN 'Notice of fine and due date'
    When  Trial_Code LIKE '%NIC%'  THEN 'Notice of impending conviction'
    WHEN  Trial_Code LIKE '%NOT%'  THEN 'Notice of trial'
	WHEN  Trial_Code LIKE '%ORG%'  THEN 'Reopen outcome guilty / impose set fine'
    WHEN  Trial_Code LIKE '%ORT%'  THEN 'Reopen outcome conviction struck / new trial'
    WHEN  Trial_Code LIKE '%SOC%'  THEN 'Strike out conviction'
    WHEN  Trial_Code LIKE '%SOCR%' THEN 'Request to strike out conviction'
    When  Trial_Code LIKE '%TOA%'  THEN 'Trial outcome adjourned'
	WHEN  Trial_Code LIKE '%TOD%'  THEN 'Trial outcome denied'
    WHEN  Trial_Code LIKE '%TOU%'  THEN 'Trial outcome convicted'
    When  Trial_Code LIKE '%TR%'   THEN 'Trial request'
    WHEN  Trial_Code LIKE '%TRA%'  THEN 'Trial request accepted'
    WHEN  Trial_Code LIKE '%TS%'   THEN 'Trial scheduled'
    When  Trial_Code LIKE '%%'     THEN 'Dealt with prior to notices being sent'
	ELSE NULL
END;

select *
from tickets_2016_17;

CREATE TABLE tickets_2017 (
    id_Column MEDIUMINT NOT NULL AUTO_INCREMENT PRIMARY KEY,
    Issue_No VARCHAR(8),
    Issue_Date DATE,
    Issue_Time TIME,
    Agency VARCHAR(29),
    Officer_Badge VARCHAR(5),
    Beat VARCHAR(4),
    VIOCode VARCHAR(20),
    VIODescription VARCHAR(70),
    VIOType VARCHAR(40),
    VIOFine VARCHAR(5),
    VIOlateFee VARCHAR(3),
    Street VARCHAR(45),
    a_between VARCHAR(25),
    a_and VARCHAR(25),
    side_of_street VARCHAR(10),
    meter_number VARCHAR(10),
    total_voided VARCHAR(10),
    total_non_cash_credit VARCHAR(10),
    total_fines_and_fees VARCHAR(10),
    total_credits VARCHAR(10),
    total_fines VARCHAR(10),
    amount_due VARCHAR(10),
    due_date DATE,
    REC_Status VARCHAR(2),
    REC_Status_Date DATE,
    REC_Cleared_Reason VARCHAR(2),
    Void_Status VARCHAR(2),
    Review_Code VARCHAR(3),
    Trial_Code VARCHAR(5)
);

ALTER TABLE tickets_2017 MODIFY REC_Cleared_Reason VARCHAR(50);
ALTER TABLE tickets_2017 MODIFY Void_Status VARCHAR(50);
ALTER TABLE tickets_2017 MODIFY Review_Code VARCHAR(50);
ALTER TABLE tickets_2017 MODIFY Trial_Code VARCHAR(100);

 UPDATE tickets_2017
SET REC_Cleared_Reason = CASE 
	WHEN  REC_Cleared_Reason = 'DP'  THEN 'Payment at the MTO or at a Collections Agency'
	WHEN  REC_Cleared_Reason = 'PD' THEN 'Paid'
    WHEN  REC_Cleared_Reason = 'SP' THEN 'Suspended'
    WHEN  REC_Cleared_Reason = 'VO' THEN 'Void'
    WHEN  REC_Cleared_Reason = 'XX' THEN 'Open'
	ELSE NULL
END;
   
   UPDATE tickets_2017
SET Review_Code = CASE 
	WHEN  Review_Code = 'ROD'  THEN 'Review outcome denied'
	WHEN  Review_Code = 'ROU' THEN 'Review outcome upheld'
    WHEN  Review_Code = 'RR' THEN 'Review requested'
    WHEN  Review_Code = 'RRA' THEN 'Review request accepted'
    WHEN  Review_Code = 'RRD' THEN 'Review request denied'
    When Review_Code = '' THEN 'No review'
	ELSE NULL
END;


   UPDATE tickets_2017
SET Trial_Code = CASE 
	WHEN  Trial_Code LIKE '%AOD%'  THEN 'Appeal outcome denied'
	WHEN  Trial_Code LIKE '%AON%'  THEN 'Appeal outcome withdrawn'
    WHEN  Trial_Code LIKE '%AOS%'  THEN 'Appeal outcome suspended'
    WHEN  Trial_Code LIKE '%CFR%'  THEN 'Conviction of failure to respond'
    WHEN  Trial_Code LIKE '%CRC%'  THEN 'Certificate requesting conviction'
    When  Trial_Code LIKE '%CRPD%' THEN 'Certificate requesting plate denial'
	WHEN  Trial_Code LIKE '%JRA%'  THEN 'Adjournment request accepted'
    WHEN  Trial_Code LIKE '%NFDD%' THEN 'Notice of fine and due date'
    When  Trial_Code LIKE '%NIC%'  THEN 'Notice of impending conviction'
    WHEN  Trial_Code LIKE '%NOT%'  THEN 'Notice of trial'
	WHEN  Trial_Code LIKE '%ORG%'  THEN 'Reopen outcome guilty / impose set fine'
    WHEN  Trial_Code LIKE '%ORT%'  THEN 'Reopen outcome conviction struck / new trial'
    WHEN  Trial_Code LIKE '%SOC%'  THEN 'Strike out conviction'
    WHEN  Trial_Code LIKE '%SOCR%' THEN 'Request to strike out conviction'
    When  Trial_Code LIKE '%TOA%'  THEN 'Trial outcome adjourned'
	WHEN  Trial_Code LIKE '%TOD%'  THEN 'Trial outcome denied'
    WHEN  Trial_Code LIKE '%TOU%'  THEN 'Trial outcome convicted'
    When  Trial_Code LIKE '%TR%'   THEN 'Trial request'
    WHEN  Trial_Code LIKE '%TRA%'  THEN 'Trial request accepted'
    WHEN  Trial_Code LIKE '%TS%'   THEN 'Trial scheduled'
    When  Trial_Code LIKE '%%'     THEN 'Dealt with prior to notices being sent'
	ELSE NULL
END;

select *
from tickets_2017;

    CREATE TABLE tickets_2018 (
    id_Column MEDIUMINT NOT NULL AUTO_INCREMENT PRIMARY KEY,
    Issue_No VARCHAR(8),
    Issue_Date DATE,
    Issue_Time TIME,
    Agency VARCHAR(29),
    Officer_Badge VARCHAR(5),
    Beat VARCHAR(4),
    VIOCode VARCHAR(20),
    VIODescription VARCHAR(70),
    VIOType VARCHAR(40),
    VIOFine VARCHAR(5),
    VIOlateFee VARCHAR(3),
    Street VARCHAR(45),
    a_between VARCHAR(25),
    a_and VARCHAR(25),
    side_of_street VARCHAR(10),
    meter_number VARCHAR(10),
    total_voided VARCHAR(10),
    total_non_cash_credit VARCHAR(10),
    total_fines_and_fees VARCHAR(10),
    total_credits VARCHAR(10),
    total_fines VARCHAR(10),
    amount_due VARCHAR(10),
    due_date DATE,
    REC_Status VARCHAR(2),
    REC_Status_Date DATE,
    REC_Cleared_Reason VARCHAR(2),
    Void_Status VARCHAR(2),
    Review_Code VARCHAR(3),
    Trial_Code VARCHAR(5)
);

ALTER TABLE tickets_2018 MODIFY REC_Cleared_Reason VARCHAR(50);
ALTER TABLE tickets_2018 MODIFY Void_Status VARCHAR(50);
ALTER TABLE tickets_2018 MODIFY Review_Code VARCHAR(50);
ALTER TABLE tickets_2018 MODIFY Trial_Code VARCHAR(100);

 UPDATE tickets_2018
SET REC_Cleared_Reason = CASE 
	WHEN  REC_Cleared_Reason = 'DP'  THEN 'Payment at the MTO or at a Collections Agency'
	WHEN  REC_Cleared_Reason = 'PD' THEN 'Paid'
    WHEN  REC_Cleared_Reason = 'SP' THEN 'Suspended'
    WHEN  REC_Cleared_Reason = 'VO' THEN 'Void'
    WHEN  REC_Cleared_Reason = 'XX' THEN 'Open'
	ELSE NULL
END;
   
   UPDATE tickets_2018
SET Review_Code = CASE 
	WHEN  Review_Code = 'ROD'  THEN 'Review outcome denied'
	WHEN  Review_Code = 'ROU' THEN 'Review outcome upheld'
    WHEN  Review_Code = 'RR' THEN 'Review requested'
    WHEN  Review_Code = 'RRA' THEN 'Review request accepted'
    WHEN  Review_Code = 'RRD' THEN 'Review request denied'
    When Review_Code = '' THEN 'No review'
	ELSE NULL
END;


   UPDATE tickets_2018
SET Trial_Code = CASE 
	WHEN  Trial_Code LIKE '%AOD%'  THEN 'Appeal outcome denied'
	WHEN  Trial_Code LIKE '%AON%'  THEN 'Appeal outcome withdrawn'
    WHEN  Trial_Code LIKE '%AOS%'  THEN 'Appeal outcome suspended'
    WHEN  Trial_Code LIKE '%CFR%'  THEN 'Conviction of failure to respond'
    WHEN  Trial_Code LIKE '%CRC%'  THEN 'Certificate requesting conviction'
    When  Trial_Code LIKE '%CRPD%' THEN 'Certificate requesting plate denial'
	WHEN  Trial_Code LIKE '%JRA%'  THEN 'Adjournment request accepted'
    WHEN  Trial_Code LIKE '%NFDD%' THEN 'Notice of fine and due date'
    When  Trial_Code LIKE '%NIC%'  THEN 'Notice of impending conviction'
    WHEN  Trial_Code LIKE '%NOT%'  THEN 'Notice of trial'
	WHEN  Trial_Code LIKE '%ORG%'  THEN 'Reopen outcome guilty / impose set fine'
    WHEN  Trial_Code LIKE '%ORT%'  THEN 'Reopen outcome conviction struck / new trial'
    WHEN  Trial_Code LIKE '%SOC%'  THEN 'Strike out conviction'
    WHEN  Trial_Code LIKE '%SOCR%' THEN 'Request to strike out conviction'
    When  Trial_Code LIKE '%TOA%'  THEN 'Trial outcome adjourned'
	WHEN  Trial_Code LIKE '%TOD%'  THEN 'Trial outcome denied'
    WHEN  Trial_Code LIKE '%TOU%'  THEN 'Trial outcome convicted'
    When  Trial_Code LIKE '%TR%'   THEN 'Trial request'
    WHEN  Trial_Code LIKE '%TRA%'  THEN 'Trial request accepted'
    WHEN  Trial_Code LIKE '%TS%'   THEN 'Trial scheduled'
    When  Trial_Code LIKE '%%'     THEN 'Dealt with prior to notices being sent'
	ELSE NULL
END;

select *
from tickets_2018;


CREATE TABLE tickets_2018_19 (
    id_Column MEDIUMINT NOT NULL AUTO_INCREMENT PRIMARY KEY,
    Issue_No VARCHAR(8),
    Issue_Date DATE,
    Issue_Time TIME,
    Agency VARCHAR(29),
    Officer_Badge VARCHAR(5),
    Beat VARCHAR(4),
    VIOCode VARCHAR(20),
    VIODescription VARCHAR(70),
    VIOType VARCHAR(40),
    VIOFine VARCHAR(5),
    VIOlateFee VARCHAR(3),
    Street VARCHAR(45),
    a_between VARCHAR(25),
    a_and VARCHAR(25),
    side_of_street VARCHAR(10),
    meter_number VARCHAR(10),
    total_voided VARCHAR(10),
    total_non_cash_credit VARCHAR(10),
    total_fines_and_fees VARCHAR(10),
    total_credits VARCHAR(10),
    total_fines VARCHAR(10),
    amount_due VARCHAR(10),
    due_date DATE,
    REC_Status VARCHAR(2),
    REC_Status_Date DATE,
    REC_Cleared_Reason VARCHAR(2),
    Void_Status VARCHAR(2),
    Review_Code VARCHAR(3),
    Trial_Code VARCHAR(5)
);

ALTER TABLE tickets_2018_19 MODIFY REC_Cleared_Reason VARCHAR(50);
ALTER TABLE tickets_2018_19 MODIFY Void_Status VARCHAR(50);
ALTER TABLE tickets_2018_19 MODIFY Review_Code VARCHAR(50);
ALTER TABLE tickets_2018_19 MODIFY Trial_Code VARCHAR(100);

 UPDATE tickets_2018_19
SET REC_Cleared_Reason = CASE 
	WHEN  REC_Cleared_Reason = 'DP'  THEN 'Payment at the MTO or at a Collections Agency'
	WHEN  REC_Cleared_Reason = 'PD' THEN 'Paid'
    WHEN  REC_Cleared_Reason = 'SP' THEN 'Suspended'
    WHEN  REC_Cleared_Reason = 'VO' THEN 'Void'
    WHEN  REC_Cleared_Reason = 'XX' THEN 'Open'
	ELSE NULL
END;
   
   UPDATE tickets_2018_19
SET Review_Code = CASE 
	WHEN  Review_Code = 'ROD'  THEN 'Review outcome denied'
	WHEN  Review_Code = 'ROU' THEN 'Review outcome upheld'
    WHEN  Review_Code = 'RR' THEN 'Review requested'
    WHEN  Review_Code = 'RRA' THEN 'Review request accepted'
    WHEN  Review_Code = 'RRD' THEN 'Review request denied'
    When Review_Code = '' THEN 'No review'
	ELSE NULL
END;


   UPDATE tickets_2018_19
SET Trial_Code = CASE 
	WHEN  Trial_Code LIKE '%AOD%'  THEN 'Appeal outcome denied'
	WHEN  Trial_Code LIKE '%AON%'  THEN 'Appeal outcome withdrawn'
    WHEN  Trial_Code LIKE '%AOS%'  THEN 'Appeal outcome suspended'
    WHEN  Trial_Code LIKE '%CFR%'  THEN 'Conviction of failure to respond'
    WHEN  Trial_Code LIKE '%CRC%'  THEN 'Certificate requesting conviction'
    When  Trial_Code LIKE '%CRPD%' THEN 'Certificate requesting plate denial'
	WHEN  Trial_Code LIKE '%JRA%'  THEN 'Adjournment request accepted'
    WHEN  Trial_Code LIKE '%NFDD%' THEN 'Notice of fine and due date'
    When  Trial_Code LIKE '%NIC%'  THEN 'Notice of impending conviction'
    WHEN  Trial_Code LIKE '%NOT%'  THEN 'Notice of trial'
	WHEN  Trial_Code LIKE '%ORG%'  THEN 'Reopen outcome guilty / impose set fine'
    WHEN  Trial_Code LIKE '%ORT%'  THEN 'Reopen outcome conviction struck / new trial'
    WHEN  Trial_Code LIKE '%SOC%'  THEN 'Strike out conviction'
    WHEN  Trial_Code LIKE '%SOCR%' THEN 'Request to strike out conviction'
    When  Trial_Code LIKE '%TOA%'  THEN 'Trial outcome adjourned'
	WHEN  Trial_Code LIKE '%TOD%'  THEN 'Trial outcome denied'
    WHEN  Trial_Code LIKE '%TOU%'  THEN 'Trial outcome convicted'
    When  Trial_Code LIKE '%TR%'   THEN 'Trial request'
    WHEN  Trial_Code LIKE '%TRA%'  THEN 'Trial request accepted'
    WHEN  Trial_Code LIKE '%TS%'   THEN 'Trial scheduled'
    When  Trial_Code LIKE '%%'     THEN 'Dealt with prior to notices being sent'
	ELSE NULL
END;


CREATE TABLE tickets_2019_20 (
    id_Column MEDIUMINT NOT NULL AUTO_INCREMENT PRIMARY KEY,
    Issue_No VARCHAR(8),
    Issue_Date DATE,
    Issue_Time TIME,
    Agency VARCHAR(29),
    Officer_Badge VARCHAR(5),
    Beat VARCHAR(4),
    VIOCode VARCHAR(20),
    VIODescription VARCHAR(70),
    VIOType VARCHAR(40),
    VIOFine VARCHAR(5),
    VIOlateFee VARCHAR(3),
    Street VARCHAR(45),
    a_between VARCHAR(25),
    a_and VARCHAR(25),
    side_of_street VARCHAR(10),
    meter_number VARCHAR(10),
    total_voided VARCHAR(10),
    total_non_cash_credit VARCHAR(10),
    total_fines_and_fees VARCHAR(10),
    total_credits VARCHAR(10),
    total_fines VARCHAR(10),
    amount_due VARCHAR(10),
    due_date DATE,
    REC_Status VARCHAR(2),
    REC_Status_Date DATE,
    REC_Cleared_Reason VARCHAR(20),
    Void_Status VARCHAR(2),
    Review_Code VARCHAR(30),
    Trial_Code VARCHAR(5)
);

drop table tickets_2019_20;

ALTER TABLE tickets_2019_20  MODIFY REC_Cleared_Reason VARCHAR(50);
ALTER TABLE tickets_2019_20  MODIFY Void_Status VARCHAR(50);
ALTER TABLE tickets_2019_20  MODIFY Review_Code VARCHAR(50);
ALTER TABLE tickets_2019_20  MODIFY Trial_Code VARCHAR(100);

 UPDATE tickets_2019_20 
SET REC_Cleared_Reason = CASE 
	WHEN  REC_Cleared_Reason = 'DP'  THEN 'Payment at the MTO or at a Collections Agency'
	WHEN  REC_Cleared_Reason = 'PD' THEN 'Paid'
    WHEN  REC_Cleared_Reason = 'SP' THEN 'Suspended'
    WHEN  REC_Cleared_Reason = 'VO' THEN 'Void'
    WHEN  REC_Cleared_Reason = 'XX' THEN 'Open'
	ELSE NULL
END;
   
   UPDATE tickets_2019_20 
SET Review_Code = CASE 
	WHEN  Review_Code = 'ROD'  THEN 'Review outcome denied'
	WHEN  Review_Code = 'ROU' THEN 'Review outcome upheld'
    WHEN  Review_Code = 'RR' THEN 'Review requested'
    WHEN  Review_Code = 'RRA' THEN 'Review request accepted'
    WHEN  Review_Code = 'RRD' THEN 'Review request denied'
    When Review_Code = '' THEN 'No review'
	ELSE NULL
END;


   UPDATE tickets_2019_20 
SET Trial_Code = CASE 
	WHEN  Trial_Code LIKE '%AOD%'  THEN 'Appeal outcome denied'
	WHEN  Trial_Code LIKE '%AON%'  THEN 'Appeal outcome withdrawn'
    WHEN  Trial_Code LIKE '%AOS%'  THEN 'Appeal outcome suspended'
    WHEN  Trial_Code LIKE '%CFR%'  THEN 'Conviction of failure to respond'
    WHEN  Trial_Code LIKE '%CRC%'  THEN 'Certificate requesting conviction'
    When  Trial_Code LIKE '%CRPD%' THEN 'Certificate requesting plate denial'
	WHEN  Trial_Code LIKE '%JRA%'  THEN 'Adjournment request accepted'
    WHEN  Trial_Code LIKE '%NFDD%' THEN 'Notice of fine and due date'
    When  Trial_Code LIKE '%NIC%'  THEN 'Notice of impending conviction'
    WHEN  Trial_Code LIKE '%NOT%'  THEN 'Notice of trial'
	WHEN  Trial_Code LIKE '%ORG%'  THEN 'Reopen outcome guilty / impose set fine'
    WHEN  Trial_Code LIKE '%ORT%'  THEN 'Reopen outcome conviction struck / new trial'
    WHEN  Trial_Code LIKE '%SOC%'  THEN 'Strike out conviction'
    WHEN  Trial_Code LIKE '%SOCR%' THEN 'Request to strike out conviction'
    When  Trial_Code LIKE '%TOA%'  THEN 'Trial outcome adjourned'
	WHEN  Trial_Code LIKE '%TOD%'  THEN 'Trial outcome denied'
    WHEN  Trial_Code LIKE '%TOU%'  THEN 'Trial outcome convicted'
    When  Trial_Code LIKE '%TR%'   THEN 'Trial request'
    WHEN  Trial_Code LIKE '%TRA%'  THEN 'Trial request accepted'
    WHEN  Trial_Code LIKE '%TS%'   THEN 'Trial scheduled'
    When  Trial_Code LIKE '%%'     THEN 'Dealt with prior to notices being sent'
	ELSE NULL
END;










select *
from tickets_2018_19;

#2010
load data local infile 
"c:\\tickets_2010.csv"
into Table tickets_2010
character set 'utf8'
	Fields terminated by "," enclosed by """" Lines terminated by "\n"
 Ignore 3 Lines
(Issue_No, @Issue_Date, @Issue_Time, Agency, Officer_Badge, 
Beat, VIOCode, VIODescription, VIOType, VIOFine, 
VIOlateFee, Street, a_between, a_and, side_of_street ,
meter_number, total_voided, total_non_cash_credit , total_fines_and_fees, total_credits, 
total_fines, amount_due, @due_date, REC_Status, @REC_Status_Date, 
REC_Cleared_Reason, Void_Status, Review_Code, Trial_Code)
	set Issue_Date = str_to_date(@Issue_Date, '%d-%b-%y'),
	issue_time = str_to_date(@Issue_Time,'%l:%i%p'),
    due_date = str_to_date(@due_date, '%d-%b-%y'),
    REC_Status_Date = str_to_date(@REC_Status_Date, '%d-%b-%y');
    
#2011
load data local infile 
"c:\\tickets_2011.csv"
into Table tickets_2011
character set 'utf8'
	Fields terminated by "," enclosed by """" Lines terminated by "\n"
 Ignore 3 Lines
(Issue_No, @Issue_Date, @Issue_Time, Agency, Officer_Badge, 
Beat, VIOCode, VIODescription, VIOType, VIOFine, 
VIOlateFee, Street, a_between, a_and, side_of_street ,
meter_number, total_voided, total_non_cash_credit , total_fines_and_fees, total_credits, 
total_fines, amount_due, @due_date, REC_Status, @REC_Status_Date, 
REC_Cleared_Reason, Void_Status, Review_Code, Trial_Code)
	set Issue_Date = str_to_date(@Issue_Date, '%d-%b-%y'),
	issue_time = str_to_date(@Issue_Time,'%l:%i%p'),
    due_date = str_to_date(@due_date, '%d-%b-%y'),
    REC_Status_Date = str_to_date(@REC_Status_Date, '%d-%b-%y');

#2012
load data local infile 
"c:\\tickets_2012.csv"
into Table tickets_2012
character set 'utf8'
	Fields terminated by "," enclosed by """" Lines terminated by "\n"
 Ignore 3 Lines
(Issue_No, @Issue_Date, @Issue_Time, Agency, Officer_Badge, 
Beat, VIOCode, VIODescription, VIOType, VIOFine, 
VIOlateFee, Street, a_between, a_and, side_of_street ,
meter_number, total_voided,total_non_cash_credit , total_fines_and_fees, total_credits, 
total_fines, amount_due, @due_date, REC_Status, @REC_Status_Date, 
REC_Cleared_Reason, Void_Status, Review_Code, Trial_Code)
	set Issue_Date = str_to_date(@Issue_Date, '%d-%b-%y'),
	issue_time = str_to_date(@Issue_Time,'%l:%i%p'),
    due_date = str_to_date(@due_date, '%d-%b-%y'),
    REC_Status_Date = str_to_date(@REC_Status_Date, '%d-%b-%y');
    
#2013
load data local infile
"c:\\tickets_2013.csv"
into Table tickets_2013
character set 'utf8'
	Fields terminated by "," enclosed by """" Lines terminated by "\n"
 Ignore 3 Lines
(Issue_No, @Issue_Date, @Issue_Time, Agency, Officer_Badge, 
Beat, VIOCode, VIODescription, VIOType, VIOFine, 
VIOlateFee, Street, a_between, a_and, side_of_street ,
meter_number, total_voided,total_non_cash_credit , total_fines_and_fees, total_credits, 
total_fines, amount_due, @due_date, REC_Status, @REC_Status_Date, 
REC_Cleared_Reason, Void_Status, Review_Code, Trial_Code)
	set Issue_Date = str_to_date(@Issue_Date, '%d-%b-%y'),
	issue_time = str_to_date(@Issue_Time,'%l:%i%p'),
    due_date = str_to_date(@due_date, '%d-%b-%y'),
    REC_Status_Date = str_to_date(@REC_Status_Date, '%d-%b-%y');
    
#2014
load data local infile 
"c:\\tickets_2014.csv"
into Table tickets_2014
character set 'utf8'
	Fields terminated by "," enclosed by """" Lines terminated by "\n"
 Ignore 3 Lines
(Issue_No, @Issue_Date, @Issue_Time, Agency, Officer_Badge, 
Beat, VIOCode, VIODescription, VIOType, VIOFine, 
VIOlateFee, Street, a_between, a_and, side_of_street ,
meter_number, total_voided,total_non_cash_credit , total_fines_and_fees, total_credits, 
total_fines, amount_due, @due_date, REC_Status, @REC_Status_Date, 
REC_Cleared_Reason, Void_Status, Review_Code, Trial_Code)
	set Issue_Date = str_to_date(@Issue_Date, '%d-%b-%y'),
	issue_time = str_to_date(@Issue_Time,'%l:%i%p'),
    due_date = str_to_date(@due_date, '%d-%b-%y'),
    REC_Status_Date = str_to_date(@REC_Status_Date, '%d-%b-%y');
    
#2015
load data local infile 
"c:\\tickets_2015.csv"
into Table tickets_2015
character set 'utf8'
	Fields terminated by "," enclosed by """" Lines terminated by "\n"
 Ignore 3 Lines
(Issue_No, Issue_Date, @Issue_Time, Agency, Officer_Badge,
Beat, VIOCode, VIODescription, VIOType, VIOFine,
VIOlateFee, Street, a_between, a_and, side_of_street,
meter_number, total_voided, total_non_cash_credit , total_fines_and_fees, total_credits,
total_fines, amount_due, due_date, REC_Status, REC_Status_Date,
REC_Cleared_Reason, Void_Status, Review_Code, Trial_Code)
	set issue_time = str_to_date(@Issue_Time,'%l:%i%p');
    
    select *
    from tickets_2015
    order by Issue_Date desc
    limit 100;
    
  #2015-16 
load data local infile 
"c:\\tickets_2015_16.csv"
into Table tickets_2015_16
character set 'utf8'
	Fields terminated by "," enclosed by """" Lines terminated by "\n"
 Ignore 1 Lines
(Issue_No, @Issue_Date, @Issue_Time, Agency, Officer_Badge,
Beat, VIOCode, VIODescription, VIOType, VIOFine,
VIOlateFee, Street, a_between, a_and, side_of_street,
meter_number, total_voided, total_non_cash_credit , total_fines_and_fees, total_credits,
total_fines, amount_due, @due_date, REC_Status, @REC_Status_Date,
REC_Cleared_Reason, Void_Status, Review_Code, Trial_Code)
	set Issue_Date = str_to_date(@Issue_Date, '%d-%b-%y'),
	issue_time = str_to_date(@Issue_Time,'%l:%i%p'),
    due_date = str_to_date(@due_date, '%d-%b-%y'),
    REC_Status_Date = str_to_date(@REC_Status_Date, '%d-%b-%y');
      
      
    select *
    from tickets_2015_16
    order by due_date asc;
    
    
    #2016-17 
load data local infile 
"c:\\tickets_2016_17.csv"
into Table tickets_2016_17
character set 'utf8'
	Fields terminated by "," enclosed by """" Lines terminated by "\n"
 Ignore 1 Lines
(Issue_No, @Issue_Date, @Issue_Time, Agency, Officer_Badge,
Beat, VIOCode, VIODescription, VIOType, VIOFine,
VIOlateFee, Street, a_between, a_and, side_of_street,
meter_number, total_voided, total_non_cash_credit , total_fines_and_fees, total_credits,
total_fines, amount_due, @due_date, REC_Status, @REC_Status_Date,
REC_Cleared_Reason, Void_Status, Review_Code, Trial_Code)
	set Issue_Date = str_to_date(@Issue_Date, '%d-%b-%y'),
	issue_time = str_to_date(@Issue_Time,'%l:%i%p'),
    due_date = str_to_date(@due_date, '%d-%b-%y'),
    REC_Status_Date = str_to_date(@REC_Status_Date, '%d-%b-%y');
    
    select count(*)
    from tickets_2016_17;
    
    
    select *
    from tickets_2016_17
    order by Issue_Date desc;
    
    #2017
load data local infile 
"C:\\ParkingTicket_A-2018-00359_POA_2017_CLEAN.csv"
into Table tickets_2017
character set 'utf8'
	Fields terminated by "," enclosed by """" Lines terminated by "\n"
 Ignore 1 Lines
(Issue_No, @Issue_Date, @Issue_Time, Agency, Officer_Badge, 
Beat, VIOCode, VIODescription, VIOType, VIOFine, 
VIOlateFee, Street, a_between, a_and, side_of_street ,
meter_number, total_voided, total_non_cash_credit , total_fines_and_fees, total_credits, 
total_fines, amount_due, @due_date, REC_Status, @REC_Status_Date, 
REC_Cleared_Reason, Void_Status, Review_Code, Trial_Code)
	set Issue_Date = str_to_date(@Issue_Date, '%d/%m/%Y'),
	issue_time = str_to_date(@Issue_Time,'%l:%i%p'),
    due_date = str_to_date(@due_date, '%d-%b-%y'),
    REC_Status_Date = str_to_date(@REC_Status_Date, '%d-%b-%y');
    
    select *
    from tickets_2017
    limit 100;
        
    #2018
load data local infile 
"C:\\ParkingTicket_A-2018-00359_POA_2018_CLEAN.csv"
into Table tickets_2018
character set 'utf8'
	Fields terminated by "," enclosed by """" Lines terminated by "\n"
 Ignore 1 Lines
(Issue_No, @Issue_Date, @Issue_Time, Agency, Officer_Badge, 
Beat, VIOCode, VIODescription, VIOType, VIOFine, 
VIOlateFee, Street, a_between, a_and, side_of_street ,
meter_number, total_voided, total_non_cash_credit , total_fines_and_fees, total_credits, 
total_fines, amount_due, @due_date, REC_Status, @REC_Status_Date, 
REC_Cleared_Reason, Void_Status, Review_Code, Trial_Code)
	set Issue_Date = str_to_date(@Issue_Date, '%d/%m/%Y'),
	issue_time = str_to_date(@Issue_Time,'%l:%i%p'),
    due_date = str_to_date(@due_date, '%d/%m/%Y'),
    REC_Status_Date = str_to_date(@REC_Status_Date, '%d/%m/%Y');
    
    select *
    from tickets_2018
    order by issue_date desc
    limit 100;
    
    load data local infile 
"C:\\tickets_2018-19.csv"
into Table tickets_2018_19
character set 'utf8'
	Fields terminated by "," enclosed by """" Lines terminated by "\n"
 Ignore 1 Lines
(Issue_No, @Issue_Date, @Issue_Time, Agency, Officer_Badge, 
Beat, VIOCode, VIODescription, VIOType, VIOFine, 
VIOlateFee, Street, a_between, a_and, side_of_street ,
meter_number, total_voided, total_non_cash_credit , total_fines_and_fees, total_credits, 
total_fines, amount_due, @due_date, REC_Status, @REC_Status_Date, 
REC_Cleared_Reason, Void_Status, Review_Code, Trial_Code)
	set Issue_Date = str_to_date(@Issue_Date, '%d/%m/%Y'),
	issue_time = str_to_date(@Issue_Time,'%l:%i%p'),
    due_date = str_to_date(@due_date, '%d/%m/%Y'),
    REC_Status_Date = str_to_date(@REC_Status_Date, '%d/%m/%Y');
    
    select *
    from tickets_2018;
    
        load data local infile 
"C:\\A-2020-00281 Release_copy.csv"
into Table tickets_2019_20
character set 'utf8'
	Fields terminated by "," enclosed by """" Lines terminated by "\n"
 Ignore 1 Lines
(Issue_No, @Issue_Date, @Issue_Time, Agency, Officer_Badge, 
Beat, VIOCode, VIODescription, VIOType, VIOFine, 
VIOlateFee, Street, a_between, a_and, side_of_street ,
meter_number, total_voided, total_non_cash_credit , total_fines_and_fees, total_credits, 
total_fines, amount_due, due_date, REC_Status, REC_Status_Date, 
REC_Cleared_Reason, Void_Status, Review_Code, Trial_Code)
	set Issue_Date = str_to_date(@Issue_Date, '%d/%m/%Y'),
	issue_time = str_to_date(@Issue_Time,'%l:%i%p');
    
    
    ###due_date = str_to_date(@due_date, '%d/%m/%Y'),
    ###REC_Status_Date = str_to_date(@REC_Status_Date, '%d/%m/%Y');
    
      
    select *
    from tickets_2019_20;
    
    
    
    select *
    from tickets_2018;
    
    
    
    
    
    
    
    
    select sum(total_fines_and_fees) as total
    from tickets_2018;
    
    ####Create the master table or view;
    
	create view master_view as 
	select * from tickets_2010 Union all
	select * from tickets_2011 Union all
	select * from tickets_2012 Union all
	select * from tickets_2013 Union all
    select * from tickets_2014 Union all
	select * from tickets_2015 Union all
	select * from tickets_2015_16 Union all
    select * from tickets_2016_17 Union all
    select * from tickets_2017 Union all
    select * from tickets_2018 Union all
    select * from tickets_2018_19 Union all
    select * from tickets_2019_20;
    
    drop view master_view; 
    
    select count(*)
    from master_view
    where Issue_Date > '2015-12-31';
    
    #### 1,734,005 records #####
    
    create table ParkingTickets_2015_2020 select *, concat_ws(' ',Street,'between',a_between,'and',a_and,'and',side_of_street) Address
    from master_view
    where Issue_Date > '2015-12-31';
    
    drop table parkingtickets_2015_2020;
    
    select year(Issue_Date) year, count(*)
    from parkingtickets_2015_2020
    group by year
    order by year(Issue_Date) desc;
    
    select *
    from parkingtickets_2015_2020
    where  Issue_Date> '2019-12-31';
    
    
    
    
    
   select *, left(Issue_Date, 4) Year 
   from master_view
   where left(Issue_Date,4) >'2015'
   limit 100;
   
   ##### 3,916,710 records - takes about one minute to run the query #####
   
   
   select *
    from master_view
        order by Issue_Date desc
        limit 100;
    
    
   
   select count(*) 
    from master_view;
    
    select *
    from master_view
    where Issue_Date > '2015-12-31'
    order by Issue_Date desc;
    
    create table Tickets_2016_July4_2019 as select *, concat_ws(' ',Street,'between',a_between,'and',a_and,'and',side_of_street) Address
    from master_view
    where Issue_Date > '2015-12-31'
    order by Issue_Date desc;
    
    drop table Tickets_2016_July4_2019;
    
    select *
    from Tickets_2016_July4_2019
    order by Issue_Date desc;
    
select count(*)
from master_view;
### this query produces 3,607,202 records

select count(*)
from tickets_all;

 
 ##### Select query statements
 
select count(id_Column) as 'Number of violations', VIODescription as 'Violation Description'
from master_view
group by VIODescription
order by count(id_Column) desc;

select Agency, count(id_Column) as 'Number of tickets'
from master_view
group by Agency
order by count(id_Column) desc;

 select Year(Issue_Date) as Year, 
format(count(total_fines_and_fees),0) as NumberOfTickets, 
format(Sum(total_fines_and_fees),1) as Total
from master_view
group by year
order by NumberOfTickets  desc;

select Officer_Badge, count(id_Column) 'Number of tickets'
from master_view
group by Officer_Badge
order by count(id_Column) desc;

select
concat_ws(' ',Street,'between',a_between,'and',a_and,'and',side_of_street) Address,
count(id_Column) 'Number of tickets'
from master_view
group by Address
order by count(id_Column) desc;
 
 select *
 from master_view
 where Issue_Date > '2019-01-01' 
 and (Agency like '%Algonquin%' or Agency like '%carleton%' 
 or Agency like '%La Cite Collegiale%' or Agency like '%University of Ottawa%');
 

 select year(Issue_Date) as Year,
format(count(total_fines_and_fees),0) NumberOfTickets, 
format(Sum(total_fines_and_fees),1) as Total
from master_view
where  Agency like '%Algonquin%' or Agency like '%carleton%' 
 or Agency like '%La Cite Collegiale%' or Agency like '%University of Ottawa%'
group by year
order by NumberOfTickets  desc;

select
concat_ws(' ',Street,'between',a_between,'and',a_and,'and',side_of_street) Address,
count(id_Column) 'Number of tickets'
from master_view
where Issue_Date >'2017-01-01'
group by Address
order by 'Number of tickets' desc;

select year(Issue_Date) as Year, 
format(count(id_Column),0) as NumberOfTickets, 
format(sum(total_fines_and_fees),0) 'Total fines'
from master_view
where Agency like '%La Cite Collegiale%'
or Agency like'%Carleton Parking%' 
or Agency like'% Univeristy of Ottawa%'
or Agency like'%Algonquin College%'
group by Year
order by NumberOfTickets desc;

select Year(Issue_Date) as Year, 
format(count(total_fines_and_fees),0) NumberOfTickets, 
format(Sum(total_fines_and_fees),1) as Total
from master_view
group by year
order by  NumberOfTickets desc;

select *
from master_view
where VIODescription = 'STOP IN A SCHOOL BUS LOADING ZONE' and Issue_Date >'2017-01-01'
order by Issue_date desc;

select Officer_Badge, count(id_Column) Number_Of_Tickets, year(Issue_Date) Year
from master_view
group by Year, Officer_Badge
order by count(id_Column) desc;

SELECT year(Issue_Date) Year, count(id_Column) NumberOfTickets, sum(total_fines) Fines
FROM master_view
group by Year
order by sum(total_fines) desc;

select sum(total_fines_and_fees)
from tickets_2016_17
where Issue_Date > '2017-01-01';

select *
from tickets_2016_17
where Issue_Date > '2017-01-01';

select sum(total_fines) Fines, count(id_Column) NumberOfTickets
from tickets_2016_17
where Issue_Date > '2017-01-01';

select count(*)
from tickets_all;

select year(issue_date) year, count(Issue_no) number
from tickets_all
group by year
order by count(Issue_no) desc;


select *
from master_view
where Issue_Date > 2018-01-01;

select year(Issue_Date) year from tickets_2018_19;
